<?php
if(!isset($_SESSION['teacher_id'])){
    echo "Not authorized";
    exit;
}

$core = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");
if(!$core) die("DB Error");

// fetch all students for dropdown
$students_res = mysqli_query($core,"SELECT id,name FROM students ORDER BY name ASC");
$all_students = [];
while($s=mysqli_fetch_assoc($students_res)) {
    $all_students[$s['id']] = $s['name'];
}

$student_id = $_GET['student_id'] ?? '';
$student = null;
$marks = [];

if($student_id){
    $student_id = mysqli_real_escape_string($core,$student_id);
    $student = mysqli_fetch_assoc(mysqli_query($core,"SELECT * FROM students WHERE id='$student_id'"));
    $marks_res = mysqli_query($core,"SELECT m.*, s.name as subject_name FROM marks m LEFT JOIN subjects s ON m.subject_id=s.id WHERE student_id='$student_id' ORDER BY term,subject_id ASC");
    while($m=mysqli_fetch_assoc($marks_res)) {
        $marks[] = $m;
    }
}
?>
<style>
.report-container {
    padding: 32px;
}

.filter-card {
    background: white;
    padding: 28px;
    border-radius: 12px;
    margin-bottom: 24px;
    border: 1px solid #e5e7eb;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.form-select {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 15px;
    background: white;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-select:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.student-info-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 28px;
    border-radius: 12px;
    margin-bottom: 24px;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
}

.student-info-card h2 {
    font-size: 24px;
    margin-bottom: 8px;
}

.student-info-card p {
    opacity: 0.9;
    font-size: 15px;
}

.report-card {
    background: white;
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid #e5e7eb;
}

.report-table {
    width: 100%;
    border-collapse: collapse;
}

.report-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.report-table th {
    padding: 16px;
    text-align: left;
    color: white;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.report-table tbody tr {
    border-bottom: 1px solid #f3f4f6;
}

.report-table tbody tr:hover {
    background: #f9fafb;
}

.report-table td {
    padding: 16px;
    color: #374151;
    font-size: 14px;
}

.marks-badge {
    display: inline-block;
    padding: 6px 14px;
    border-radius: 20px;
    font-weight: 500;
    font-size: 14px;
}

.marks-badge.high {
    background: #d1fae5;
    color: #065f46;
}

.marks-badge.medium {
    background: #fef3c7;
    color: #92400e;
}

.marks-badge.low {
    background: #fee2e2;
    color: #991b1b;
}

.empty-state {
    text-align: center;
    padding: 64px 24px;
}

.empty-icon {
    width: 100px;
    height: 100px;
    background: linear-gradient(135deg, #f3f4f6 0%, #e5e7eb 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
}

.empty-icon svg {
    width: 50px;
    height: 50px;
    color: #9ca3af;
}

.empty-state h3 {
    font-size: 20px;
    color: #1f2937;
    margin-bottom: 8px;
}

.empty-state p {
    font-size: 15px;
    color: #6b7280;
}

@media (max-width: 768px) {
    .report-container {
        padding: 20px;
    }
    
    .student-info-card h2 {
        font-size: 20px;
    }
    
    .report-card {
        overflow-x: auto;
    }
    
    .report-table {
        min-width: 500px;
    }
}
</style>

<div class="report-container">
    <div class="filter-card">
        <form method="get">
            <input type="hidden" name="page" value="report_student_marks">
            <div class="form-group">
                <label for="student_id">Select Student</label>
                <select name="student_id" id="student_id" class="form-select" onchange="this.form.submit()">
                    <option value="">-- Select Student --</option>
                    <?php foreach($all_students as $sid=>$sname){
                        $sel = ($sid==$student_id)?'selected':'';
                        echo "<option value='".htmlspecialchars($sid)."' $sel>".htmlspecialchars($sname)."</option>";
                    } ?>
                </select>
            </div>
        </form>
    </div>
    
    <?php if($student_id && $student): ?>
    <div class="student-info-card">
        <h2><?php echo htmlspecialchars($student['name']); ?></h2>
        <p>Class: <?php echo htmlspecialchars($student['class_id'] ?? 'Not assigned'); ?> | Roll No: <?php echo htmlspecialchars($student['roll_no']); ?></p>
    </div>
    
    <?php if(count($marks) > 0): ?>
    <div class="report-card">
        <table class="report-table">
            <thead>
                <tr>
                    <th>Term</th>
                    <th>Subject</th>
                    <th>Marks</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($marks as $m): 
                    $mark_val = intval($m['marks']);
                    $badge_class = $mark_val >= 70 ? 'high' : ($mark_val >= 40 ? 'medium' : 'low');
                ?>
                <tr>
                    <td><?php echo htmlspecialchars($m['term']); ?></td>
                    <td><?php echo htmlspecialchars($m['subject_name']); ?></td>
                    <td><span class="marks-badge <?php echo $badge_class; ?>"><?php echo htmlspecialchars($m['marks']); ?></span></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php else: ?>
    <div class="empty-state">
        <div class="empty-icon">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M9 11l3 3L22 4"/>
                <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
            </svg>
        </div>
        <h3>No Marks Recorded</h3>
        <p>This student doesn't have any marks recorded yet</p>
    </div>
    <?php endif; ?>
    <?php endif; ?>
</div>
