<?php
// view_students.php
if(!isset($_SESSION['teacher_id'])){
    echo "Not authorized";
    exit;
}
$tid = $_SESSION['teacher_id'];

$teach = mysqli_connect("localhost","thevkin_schlteachdb","VK_AutSchlDb","thevkin_schlteachdb");
$core  = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");
if(!$teach || !$core) die("DB Error");

// gather classes teacher has (class teacher or subject teacher)
$classes = [];
$qr = mysqli_query($teach,"SELECT DISTINCT class_id FROM (
    SELECT class_id FROM teacher_class_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'
    UNION
    SELECT class_id FROM teacher_subject_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'
) t");
while($r=mysqli_fetch_assoc($qr)){
    $cid = mysqli_real_escape_string($core,$r['class_id']);
    $c = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM classes WHERE id='{$cid}'"));
    if($c) $classes[$c['id']] = $c['name'];
}

$selected = $_POST['class_id'] ?? ($_GET['class_id'] ?? '');
$students = [];
if($selected){
    $sel = mysqli_real_escape_string($core,$selected);
    $res = mysqli_query($core,"SELECT * FROM students WHERE class_id='{$sel}' ORDER BY name ASC");
    while($s=mysqli_fetch_assoc($res)) $students[] = $s;
}
?>
<style>
.students-container {
    padding: 32px;
}

.filter-section {
    background: linear-gradient(135deg, #f0f4ff 0%, #e8edff 100%);
    padding: 24px;
    border-radius: 12px;
    margin-bottom: 24px;
    border: 1px solid #dce4ff;
}

.filter-form {
    display: flex;
    gap: 12px;
    align-items: flex-end;
    flex-wrap: wrap;
}

.form-group {
    flex: 1;
    min-width: 200px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.form-select {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 15px;
    background: white;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-select:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.btn-primary {
    padding: 12px 24px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
}

.students-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 20px;
    flex-wrap: wrap;
    gap: 12px;
}

.students-header h3 {
    font-size: 20px;
    color: #1f2937;
}

.student-count {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 14px;
}

.table-container {
    background: white;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
}

.students-table {
    width: 100%;
    border-collapse: collapse;
}

.students-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.students-table th {
    padding: 16px;
    text-align: left;
    color: white;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.students-table tbody tr {
    border-bottom: 1px solid #f3f4f6;
    transition: all 0.2s ease;
}

.students-table tbody tr:hover {
    background: #f9fafb;
}

.students-table td {
    padding: 16px;
    color: #374151;
    font-size: 14px;
}

.student-id {
    background: #f3f4f6;
    padding: 4px 10px;
    border-radius: 6px;
    font-family: monospace;
    font-size: 13px;
}

.parent-info {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.parent-name {
    color: #1f2937;
}

.parent-username {
    color: #6b7280;
    font-size: 13px;
}

.empty-state {
    text-align: center;
    padding: 64px 24px;
}

.empty-icon {
    width: 100px;
    height: 100px;
    background: linear-gradient(135deg, #f3f4f6 0%, #e5e7eb 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
}

.empty-icon svg {
    width: 50px;
    height: 50px;
    color: #9ca3af;
}

.empty-state h3 {
    font-size: 20px;
    color: #1f2937;
    margin-bottom: 8px;
}

.empty-state p {
    font-size: 15px;
    color: #6b7280;
}

@media (max-width: 768px) {
    .students-container {
        padding: 20px;
    }
    
    .filter-form {
        flex-direction: column;
    }
    
    .form-group {
        width: 100%;
    }
    
    .btn-primary {
        width: 100%;
    }
    
    .table-container {
        overflow-x: auto;
    }
    
    .students-table {
        min-width: 600px;
    }
    
    .students-table th,
    .students-table td {
        padding: 12px 8px;
        font-size: 13px;
    }
}
</style>

<div class="students-container">
    <div class="filter-section">
        <form method="post" class="filter-form">
            <div class="form-group">
                <label for="class_id">Select Class</label>
                <select name="class_id" id="class_id" class="form-select" required>
                    <option value="">-- Choose a class --</option>
                    <?php foreach($classes as $id=>$n){ 
                        $sel = ($id==$selected)?'selected':''; 
                        echo "<option value='".htmlspecialchars($id)."' $sel>".htmlspecialchars($n)."</option>"; 
                    } ?>
                </select>
            </div>
            <button type="submit" class="btn-primary">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="18" height="18" style="display: inline-block; vertical-align: middle; margin-right: 6px;">
                    <circle cx="11" cy="11" r="8"/>
                    <path d="m21 21-4.35-4.35"/>
                </svg>
                Show Students
            </button>
        </form>
    </div>
    
    <?php if($selected): ?>
        <div class="students-header">
            <h3>Students in <?php echo htmlspecialchars($classes[$selected]); ?></h3>
            <div class="student-count"><?php echo count($students); ?> Students</div>
        </div>
        
        <?php if(count($students) > 0): ?>
        <div class="table-container">
            <table class="students-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Student Name</th>
                        <th>Username</th>
                        <th>Roll No</th>
                        <th>Parent Details</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($students as $st): ?>
                    <tr>
                        <td><span class="student-id"><?php echo htmlspecialchars($st['id']); ?></span></td>
                        <td><?php echo htmlspecialchars($st['name']); ?></td>
                        <td><?php echo htmlspecialchars($st['username']); ?></td>
                        <td><?php echo htmlspecialchars($st['roll_no']); ?></td>
                        <td>
                            <div class="parent-info">
                                <span class="parent-name"><?php echo htmlspecialchars($st['parent_name']); ?></span>
                                <span class="parent-username"><?php echo htmlspecialchars($st['parent_username']); ?></span>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="empty-state">
            <div class="empty-icon">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                    <circle cx="9" cy="7" r="4"/>
                    <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                    <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                </svg>
            </div>
            <h3>No Students Found</h3>
            <p>There are no students enrolled in this class yet</p>
        </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
